import sys
import os
import time
import pyperclip
import pygetwindow
from pynput.keyboard import Controller, Listener, Key
import w3luaenv.gui as gui




OUTPUT_SCRIPT_PATH = os.path.join(os.path.abspath(os.path.dirname(__file__)), 'output_script.lua')

open(OUTPUT_SCRIPT_PATH, 'w').close() # reset

main_form = gui.create_main_form(OUTPUT_SCRIPT_PATH)

script_content = ''

controller = Controller()

last_time = time.time()




def concat_script_content(target_filepath):
    
    target_dir, target_filename = os.path.split(target_filepath)

    if not os.path.exists(target_filepath):
        main_form.log(f'{target_filename} not found', color='red')
        main_form.main_script_path = main_form.lbl_script.Text = ''
        return ''

    with open(target_filepath, 'r') as f:
        content = f.read()


    loadeds = [target_filepath]

    while 'require(' in content:

        content_lines = content.splitlines()

        i = 0

        while i < len(content_lines):

            line = content_lines[i]

            if line.lstrip().startswith('--') and 'require(' in line:
                content_lines[i] = ''
                continue

            if 'require(' in line and ')' in line:

                require_index = line.find('require(')
                require_length = len('require(')

                resto_left = line[:require_index]

                i_index = require_index + require_length

                close_index = line[i_index:].find(')') + i_index

                f_index = close_index - 1

                resto_right = line[close_index+1:]


                if line[i_index] == line[f_index] and line[i_index] in ('"', "'"):

                    script_dotpath = line[i_index+1:f_index]

                    script_name_no_ext = script_dotpath.replace('.', os.sep)

                    script_name = script_name_no_ext + '.lua'

                    filepath = os.path.join(target_dir, script_name)

                    # comprobar si es un directorio y contiene init.lua >

                    module_path = os.path.join(target_dir, script_name_no_ext)

                    if os.path.exists(module_path) and os.path.isdir(module_path):
                        
                        if os.path.exists(init_lua_path := os.path.join(module_path, 'init.lua')):

                            script_name = os.path.join(script_name_no_ext, 'init.lua')
                            filepath = init_lua_path

                    # < comprobar si es un directorio y contiene init.lua
                        
                    if filepath == target_filepath:
                        main_form.log(f'The main script ({script_name or target_filename}) cannot be required.\nThe output script cannot be generated', color='red')
                        return ''

                    content = ''


                    if not os.path.exists(filepath):
                        main_form.log(f'required <{script_name}> does not exist,\noutput script cannot be generated', color='red')
                        return ''

                    elif filepath not in loadeds:

                        with open(filepath, 'r') as f:
                            content = f.read()

                        
                        _G_def = f"_G.__w3luaenv_modules_defs['{script_dotpath}'] = function()\n\n{content}\n\nend\n\n"

                        #content_lines[0] += _G_def

                        _Gmod = f"_G.__w3luaenv_modules_loadeds['{script_dotpath}']"
                        
                        content = f"{_Gmod} = _G.__w3luaenv_modules_defs['{script_dotpath}']();\n\n"

                        loadeds.append(filepath)

                    else:
                        _Gmod = f"_G.__w3luaenv_modules_loadeds['{script_dotpath}']"
                        content = ''

                    #print(line[:i_index-len('require(')])
                    content_lines[i] = content
                    if len(resto_left.strip()) > 0 or len(resto_right.strip()) > 0:
                        content_lines[i] += resto_left + _Gmod + resto_right + '\n\n'

                    main_form.log(f'required <{script_name}> loaded')

                else:

                    main_form.log('error processing a require statement, output script cannot be generated', color='red')
                    return ''
                

                content_lines.insert(0, _G_def)


            i += 1


        content = '\n'.join(content_lines)



    content = "_G.__w3luaenv_modules_defs = {}\n\n_G.__w3luaenv_modules_loadeds = {}\n\n" + content


    with open(OUTPUT_SCRIPT_PATH, 'w') as f:
        f.write(content)


    main_form.log('output script updated', color='yellow')
    return content






def on_release(key):

    global last_time

    now = time.time()

    active_window = pygetwindow.getActiveWindow()

    if last_time < now - 1 and active_window and active_window.title == 'Trigger Editor' and key == Key.f9:

        main_form.log('F9 key press detected in the Trigger Editor', color='magenta')

        last_time = now

        controller.press(Key.ctrl_l)
        controller.press('a')
        controller.release('a')
        controller.release(Key.ctrl_l)

        main_form.log('<ctrl + a> simulated')

        controller.press(Key.backspace)
        controller.release(Key.backspace)

        main_form.log('<backspace> simulated')
            
        pyperclip.copy(script_content)

        main_form.log('output script copied to clipboard')

        controller.press(Key.ctrl_l)
        controller.press('v')
        controller.release('v')
        controller.release(Key.ctrl_l)

        main_form.log('<ctrl + v> simulated')

        controller.press(Key.ctrl_l)
        controller.press('s')
        controller.release('s')
        controller.release(Key.ctrl_l)

        main_form.log('<ctrl + s> simulated')

        controller.press(Key.ctrl_l)
        controller.press(Key.f9)
        controller.release(Key.f9)
        controller.release(Key.ctrl_l)

        main_form.log('<ctrl + F9> simulated')

        main_form.log('starting map test', color='cyan')





def get_filepaths(main_script_filepath):

    target_dir = os.path.split(main_script_filepath)[0]

    filepaths = []

    for path, dirnames, filenames in os.walk(target_dir):
        for filename in filenames:
            if filename.endswith('.lua'):
                filepath = os.path.join(path, filename)
                filepaths.append(filepath)

    return filepaths










def start_mtime_checker(main_script_filepath):

    global script_content

    with Listener(on_release=on_release):

        mtimes = {}

        filepaths = get_filepaths(main_script_filepath) #[os.path.join(TARGET_DIR, filename) for filename in os.listdir(TARGET_DIR) if filename.endswith('.lua')]

        mtimes = {fp: os.path.getmtime(fp) for fp in filepaths}

        script_content = concat_script_content(main_script_filepath)


        while True:

            for fp, mtime in mtimes.items():

                if not os.path.exists(fp):
                    script_content = concat_script_content(main_script_filepath)
                    continue

                current_mtime = os.path.getmtime(fp)

                if current_mtime > mtime:

                    project_fp = fp.replace(os.path.split(main_script_filepath)[0], "")
                    if project_fp.startswith('\\'):
                        project_fp = project_fp[1:]

                    main_form.log(f'<{project_fp}> has been modified', color='#FF8800')

                    mtimes[fp] = current_mtime

                    script_content = concat_script_content(main_script_filepath)


            filepaths_antes = [fp for fp in mtimes.keys()]

            mtimes = {fp: mtime for fp, mtime in mtimes.items() if os.path.exists(fp)}

            eliminados = [fp for fp in filepaths_antes if fp not in mtimes.keys()]

            if eliminados:
                script_content = concat_script_content(main_script_filepath)

            filepaths_ahora = get_filepaths(main_script_filepath) #[os.path.join(TARGET_DIR, filename) for filename in os.listdir(TARGET_DIR) if filename.endswith('.lua')]

            nuevos = [fp for fp in filepaths_ahora if fp not in mtimes.keys()]

            for nuevo_fp in nuevos:
                if os.path.exists(fp):
                    mtimes[nuevo_fp] = os.path.getmtime(fp)
                    script_content = concat_script_content(main_script_filepath)


            if main_form.main_script_path != main_script_filepath:
                main_form.log(f'closing <{os.path.split(main_script_filepath)[-1]}>\n', color='red')
                break

            if main_form.IsDisposed:
                sys.exit(os.EX_OK)

            time.sleep(.4)











def main():

    os.chdir(os.path.abspath(os.path.dirname(__file__)) or '.')

    main_form.log('\n<W3LuaEnv> is a free tool created by <tecnobillo>\n', color='#00FF00')

    main_form.log('Select the <main script> of your project (the entry point)', color='yellow')

    while True:

        while not main_form.main_script_path:

            time.sleep(0.5)
            
            if main_form.IsDisposed:
                sys.exit(os.EX_OK)
            else:
                continue

        script_name = os.path.split(main_form.main_script_path)[-1]

        main_form.log(f'<{script_name}> selected, its directory is the project directory', color='yellow')

        main_form.log("""
In the Trigger Editor, on the right, under 'Custom Script Code',
click the text box to focus it, then press [F9]
to update the code and test the map.
            """, color='cyan'
            )

        start_mtime_checker(main_form.main_script_path)

        time.sleep(0.5)





if __name__ == '__main__':

    main()